package gov.va.med.mhv.usermgmt.web.controller;

import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.portlet.PortletRequest;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean
@Component
@Scope("session")
public class PersonalInformationController  extends AbstractController{
	private static final long serialVersionUID = 5050128896390892884L;
	private boolean showVBHB=false;
	private boolean showMonthlyBillingStmt;
	
	
	public void authorize(ComponentSystemEvent event){
		
		PortletRequest   request = (PortletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
		FacesContext context =FacesContext.getCurrentInstance();
		if(request.getUserPrincipal() == null){
			context.getApplication().getNavigationHandler().handleNavigation(context, null, "/views/uanuthorized.xhtml");
		}
		setShowVBHB(false);
		setShowMonthlyBillingStmt(false);
		if(isPremiumAccountType()&& isDsLogonUser()){
			setShowVBHB(true);
			setShowMonthlyBillingStmt(true);
		}
	}
	
	public boolean getShowVBHB() {
		return showVBHB;
	}

	public void setShowVBHB(boolean showVBHB) {
		this.showVBHB = showVBHB;
	}

	public boolean isShowMonthlyBillingStmt() {
		return showMonthlyBillingStmt;
	}

	public void setShowMonthlyBillingStmt(boolean showMonthlyBillingStmt) {
		this.showMonthlyBillingStmt = showMonthlyBillingStmt;
	}
}